/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include regfile.h"
3.  Example calling of program:
    _RegFile( "WIN32.OCX" );
4.  Declare the following as global strings:
    szFile
5.  Must install the regsvr32.exe before calling this function
*/
prototype   _RegFile ( STRING );
/////////////////////////////////////////////////////////////////////////////
// Function: _RegFile
//
//  Purpose: This function registers files in the windows registry incase the
//           main installation fails to do so, or you prefer to have control
//           over the file registration
/////////////////////////////////////////////////////////////////////////////
function _RegFile ( szFile )
    NUMBER nResult;
    STRING szLog, szResult, szParameter, szCommand, szRegisterFile;
begin
    szRegisterFile = "regsvr32.exe"; // Windows 32bit file register
    // Look for the register exe
    if ( FindFile ( WINSYSDIR, szRegisterFile, szResult ) = 0 ) then
        szParameter = " /s " + WINSYSDIR ^ szFile; // use /s option for no prompt
        szCommand = WINSYSDIR ^ szRegisterFile;
        nResult = LaunchAppAndWait ( szCommand, szParameter, WAIT );
        //szLog = " INFO: Successfully registered " + szFile;
        //_LogIt ( szLog );
        if ( nResult < 0 ) then // Error reoutine if launchapp fails
            szLog = " ERROR: Unable to register " + szFile;
            MessageBox ( szLog, WARNING );
            //_LogIt ( szLog );
            //_Error ( szLog );
        endif;
    else // Error routine if findfile fails
        szLog = " ERROR: Unable to find " + szRegisterFile;
        MessageBox ( szLog, WARNING );
        //_LogIt ( szLog );
        //_Error ( szLog );
    endif;
end;




