/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include readonly.h"
3.  Example calling of program:
    _ReadOnly( WINDIR, "WIN.INI" );
4.  Declare the following as global strings:
    szFile, szDir
*/
prototype   _ReadOnly ( STRING,STRING );
/////////////////////////////////////////////////////////////////////////////
// Function: _ReadOnly
//
//  Purpose: This function changes files attributes to Read Only one file at
//           a time
/////////////////////////////////////////////////////////////////////////////
function _ReadOnly ( szDir,szFile )
    STRING szLog, szResult, szPathName;
begin
    if ( FindFile ( szDir, szFile, szResult ) = 0 ) then // Search for file
        szPathName = szDir ^ szFile;
        SetFileInfo ( szPathName, FILE_ATTRIBUTE, FILE_ATTR_NORMAL, "" );
    else // Error routine if findfile fails
        szLog = " ERROR: Unable to remove the read-only attribe from " + szPathName;
        MessageBox ( szLog, WARNING );
        //_LogIt ( szLog );
        //_Error ( szLog );
    endif;
    //szLog = " INFO: Successfully set " + szPathName + " attribut to READ-ONLY.";
    //_LogIt ( szLog );
end;




