/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include logit.h"
3.  Example calling of program:
    _LogIt( "This is test" );
4.  Set DIR_VER and INSTALL_LOG to the variables you want
*/
prototype   _LogIt ( STRING );
/////////////////////////////////////////////////////////////////////////////
// Function:  _LogIt
//
//  Purpose:  This function writes to a log file.  This records
//            information about the installation that is being done
/////////////////////////////////////////////////////////////////////////////
function _LogIt ( szLog )
    NUMBER  nVal;
    STRING  szDT, szVal;
    STRING  DIR_VER, INSTALL_LOG;
begin
    DIR_VER = "C:\TEST"; // Set this to the directory that you want the log
                         // file to write to
    INSTALL_LOG = "Install.log"; // Name of the log file

    if ( ExistsDir ( DIR_VER ) = NOTEXISTS ) then
        if ( CreateDir ( DIR_VER ) < 0 ) then
            // Error routine
            szLog = "ERROR: Unable to create " + DIR_VER;
            MessageBeep ( 0 );
            MessageBeep ( 0 );
            MessageBox ( szLog, SEVERE );
            abort;
        endif;
    endif;
    // Get System Date stamp
    szDT = "";
    GetSystemInfo ( DATE, nVal, szVal );
    szDT = szDT + szVal;
    // Get System Time stamp
    GetSystemInfo ( TIME, nVal, szVal );
    szDT = szDT + " " + szVal;
    // Write the time, date and message to the log file
    if ( WriteProfString ( DIR_VER ^ INSTALL_LOG, "INSTALL", szDT, szLog ) < 0 ) then
        MessageBox ( "Error: Unable to write to installation log!" , SEVERE );
    endif;
end;




