/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include error.h"
3.  Example calling of program:
    _Error( "FATAL ERROR" );
4.  Declare the following as global strings:
    szLog
*/
prototype   _Error ( STRING );
/////////////////////////////////////////////////////////////////////////////
// Function:  _Error
//
//  Purpose:  This function is called only when there is a fatal error in the
//            application, and a meesage needs to be displayed to terminate
//            the installation
/////////////////////////////////////////////////////////////////////////////
function _Error ( szLog )
begin
    if szLog = "" then
        szLog = " ERROR: An unknown error ocurred during the installation!\n\nInstallation halted.";
    endif;
    Disable ( EXIT);
    Disable ( HELP );
    Disable ( PAUSE );
    Disable ( INFO );
    Disable ( FEEDBACK_FULL );
    Disable ( STATUS );
    MessageBox ( szLog, SEVERE );
    abort;
end;




