/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include deleteline.h"
3.  Example calling of program:
    _DeleteLine( "C:\\TEST", "TEST.INI", "FRED" );
4.  Declare the following as global strings:
    szDir, szFile, szLine
*/
prototype   _DeleteLine ( STRING,STRING,STRING );
/////////////////////////////////////////////////////////////////////////////
// Function: _DeleteLine
//
//  Purpose: This function deletes a line in ini files or other text files.
//           This will delete the first occurance of the value in szLine
/////////////////////////////////////////////////////////////////////////////
function _DeleteLine ( szDir,szFile,szLine )
    NUMBER nReturn;
    STRING szLog, szReturn;
begin
    SRCDIR = szDir;
    // Check for file existance and the line in the file
    if ( FileGrep ( szFile, szLine, szReturn, nReturn, RESTART ) = 0 ) then
        if ( FileDeleteLine ( szFile, nReturn, nReturn ) < 0 ) then
            // Error routine if delete line fails
            szLog = " INFO: Unable to delete line: " + szLine + " in " + szDir ^ szFile;
            MessageBox ( szLog, WARNING );
            //_LogIt ( szLog );
            //_Error ( szLog )
        endif;
    else    // Error routine if grep fails
        szLog = " INFO: Unable to find line: " + szLine + " in " + szDir ^ szFile;
        MessageBox ( szLog, WARNING );
        //_LogIt ( szLog );
        //_Error ( szLog );
    endif;
    //szLog = " INFO: Deleted line: " + szLine + " in " + szDir ^ szFile;
    //_LogIt ( szLog );
end;




