/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include delete.h"
3.  Example calling of program:
    _Delete( "C:\\TEST", "TEST.EXE" );
4.  Declare the following as global strings:
    szDir, szFile
*/
prototype   _DeleteDir ( STRING );
/////////////////////////////////////////////////////////////////////////////
// Function: _DeleteDir
//
//  Purpose: This function deletes directories, if the directory has a file in
//           use during the deletion, all files will be deleted except for the
//           direcotry and the file that was in use at the time
/////////////////////////////////////////////////////////////////////////////
function    _DeleteDir ( szDir )
    STRING szLog;
begin
    if ( ExistsDir ( szDir ) = EXISTS ) then
        if ( DeleteDir ( szDir, ALLCONTENTS ) < 0 ) then
            // Error routine if deletedir fails
            szLog = " ERROR: unable to delete all contents of " + szDir;
            MessageBox( szLog, WARNING );
            //_LogIt ( szLog );
            //_Error ( szLog );
        endif;
    else // Error routine if the directory does not exist
        szLog = " ERROR: unable find " + szDir;
        MessageBox( szLog, WARNING );
        //_LogIt ( szLog );
        //_Error ( szLog );
    endif;
    //szLog = " INFO: " + szDir + " Directory deleted";
    //_LogIt ( szLog );
end;






