/*
1.  All error and logging functions have been commented out
    and have been replaced with messageboxes where appropriate
2.  Add this header file to the script files and include file as follows
    in your setup.rul:
    "#include createdwreg.h"
3.  Example calling of program:
    RegDBSetDefaultRoot (HKEY_LOCAL_MACHINE);
    _CreateDwReg( "\\Software\\Test", "TestValue", "007" );
4.  Declare the following as global strings:
    szKey, szName, szValue
*/
prototype   _CreateDwReg ( STRING,STRING,STRING );
/////////////////////////////////////////////////////////////////////////////
// Function: _CreateDwReg
//
//  Purpose: This function creates DWORD registry entries
/////////////////////////////////////////////////////////////////////////////
function _CreateDwReg ( szKey,szName,szValue )
    STRING szLog;
begin
    if ( RegDBCreateKeyEx ( szKey, "" ) < 0 ) then // Error routine
        szLog = " ERROR: Unable to create " + szKey + szValue + " in Regsitry";
        MessageBox( szLog, WARNING );
        //_LogIt ( szLog );
        //_Error ( szLog );
    endif;
    if ( RegDBSetKeyValueEx ( szKey, szName, REGDB_NUMBER, szValue, -1 ) < 0 ) then
        // Error routine
        szLog = " ERROR: Unable to create " + szKey + szValue + " in Regsitry";
        MessageBox ( szLog, WARNING );
        //_LogIt ( szLog );
        //_Error ( szLog );
    endif;
end;






