/*
	$Workfile:$
	$Header:$


	@doc
	@module _Uninstall.cpp - Uninstaller template |

	This file will contain the implemenation of the two functions that will be called
	before and after the uninstaller does its job.
	
	This code is Unicode compliant - if you want to compile with UNICODE, please
	define _UNICODE in the C++ preprocessor.  If you do nothing, this will compile
	to ANSI. (Delete this comment if you code to ANSI only).

	In case you are wondering about the weird tags in the code - its for a documentation
	tool called Autoduck.

	I have tested the DLL to make sure that those two functions get called.  I am including
	an InstallShield script function that shows how to patch installshield so that the 
	uninstaller loads your dll.  If you install ODBC or things like it, make sure you call
	the function in the script after installing ODBC.


	Revision History:
		1999 April 19 - Initial Revision   Friedrich Brunzema  (brunzefb@aracnet.net)

	$Log$ 
*/


#include <atlbase.h>			// to make the ATL class CRegKey work
#include <statreg.h>			// comment these "headers" out if you are
#include <statreg.cpp>			// not planning 
#include <atlimpl.cpp>			// to use the CRegKey class
#include <Windows.h>
#include <Winbase.h>
#include <Winnt.h>
#include <tchar.h>				// for Unicode compliant code
#include <winreg.h>
#include "_Uninstall.h"			// Prototypes

/*
#include "util.h"				// uncomment if you want to use my utilities
								// if you don't use the util functions, 
								// you can delete the util.cpp from the build.
*/


/* 
	Don't be tempted to put static variables here - it won't work.  Reason is:
	IS loads the DLL, calls UninstInitialize then unloads this DLL.  The unloading
	causes the static data to disappear.
*/


/*
	@func DLLMain

	This function is the main entry point into the DLL.

	@parm	HINSTANCE	| hInstance		| The instance
	@parm	DWORD		| dwReason		| Why called
	@parm	short		| digits		| The number of decimal places 
										  to use.
	@parm	LPVOID		| 				| reserved

*/
extern "C" 
BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID /*lpReserved*/)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
	}
	return TRUE;    // ok
}


/*
	@func UninstInitialize

	This function is called by the uninstaller before doing any uninstalling.
	
	@parm	HWND	| hwndDlg		| The window handle of the parent
	@parm	HANDLE	| hInst			| The instance handle of the Uninst app
	@parm	LONG	|				| reserved.
	@retval LONG  return >=0 to continue uninstalling, <0 if uninstall is to stop
*/
extern "C" LONG WINAPI 
UninstInitialize(HWND hwndDlg, HANDLE hInstanceParent, LONG)
{
	/*
		This function is called immediately before the uninstall begins.
		Add custom functionality below - for catastropical errors where
		you do not wish uninstallation to proceed, return -1
	*/


	// returning OK to the uninstaller
	return 0;
}


/*
	@func UninstUnInitialize

	This function is called by the uninstaller after finishing its uninstalling.
	
	@parm	HWND	| hwndDlg		| The window handle of the parent
	@parm	HANDLE	| hInst			| The instance handle of the Uninst app
	@parm	LONG	|				| reserved.
	@retval LONG  return >=0 to continue uninstalling, <0 if uninstall is to stop

*/
extern "C" LONG WINAPI 
UninstUnInitialize(HWND hwndDlg, HANDLE hInstanceParent, LONG)
{
/*
		This function is called immediately after the uninstall finsishes, but before
		uninstaller is unloaded.  Here's your chance to do some extra cleanup.
		Add custom functionality below - for catastropical errors where
		you do not wish uninstallation to proceed, return -1
	*/

	// return OK to uninstaller
	return 0;
}







