/*
	$Workfile:$
	$Header:$

	@doc
	@module Util.cpp - Various utility functions that can come in handy |

	While I think that the code below works, I make no guarantees - you will still
	have to do your own testing.  There are some powerful registry and file deletion
	functions which should be used very carefully. 


	This file contains the following functions:

	IsAdmin()		Checks to see if the current user is administrator on the machine
					Used to disallow non- administrators to uninstall your product

	RecurseDelete()	Deletes a subdirectory, and all its contents, but not the subdirectory
					Itself.  If you want to delete the directory itself, you will have to
					remember to change to a different current directory before deleting it
					otherwise it will fail (locked).

	RegKeyDelete()  Deletes a key in the registry, and all is subkeys.

	Revision History:

	1999 April 19 - Initial Revision   

	$Log$ 
*/

#include <atlbase.h>			// to make CRegKey work
#include <statreg.h>
#include <Windows.h>
#include <Winbase.h>
#include <Winnt.h>
#include <tchar.h>
#include <winreg.h>
#include <direct.h>
#include "Util.h"

const TCHAR FINDWHAT[]		= _T("\\*.*");
const TCHAR SOFTWARE[]		= _T("Software");	// replace with the key you use
const TCHAR MY_APP[]		= _T("MyApp");		// replace with your key

/* 
	
long CallUninstallInLibrary(HWND hwnd, HINSTANCE hInst, LPTSTR strPath);
{
	// This is how you would call another uninstall DLL from your DLL
	
	typedef LONG (__stdcall * LPUNINSTINIT)(HWND, HINSTANCE, LONG);
	HANDLE			hDLL;
	LPUNINSTINIT	UninstInitialize;
	
	hDLL = LoadLibrary(strPath);		// strPath contains full path to Uninst DLL
	if (NULL == hDLL)
	{
		// error 
	}

	// get a pointer to the function  (use "UninstUnInitialize" for the second call)
	UninstInitialize = (LPUNINSTINIT)GetProcAddress((HINSTANCE)hDLL, _T("UninstInitialize"));
	if (NULL == UninstInitialize)
	{		
		// error 
	}
	
	// call the function in the other uninstaller library
	lRet = UninstInitialize(hWnd, hInst, 0);	

	// and cleanup
	FreeLibrary((HMODULE)hDLL);
}
*/


/*
	@func RegKeyDelete

	This function is supposed to clean up after your application by deleteing
	the HKEY_LOCAL_MACHINE\Software\YourApp key and everything below.  
	BE CAREFUL WITH THIS FUNCTION, SET THE APP_KEY constant before calling, otherwise
	you can delete something important in your registry.
*/
void RegKeyDelete()
{
	CRegKey					regKey;					// registry key

	// delete the key in Local machine
	if (ERROR_SUCCESS == regKey.Open(HKEY_LOCAL_MACHINE, SOFTWARE, KEY_READ | KEY_WRITE))
	{
		regKey.RecurseDeleteKey(MY_APP);
		regKey.Close();
	}
}


/*
	@func RecurseDelete
	This function deletes everything in the current directory, but does not
	remove the directory itself. 
	
	If you want to delete the directory as well you
	do this in the Caller of RecurseDelete
		_tchdir(szDirToDelete);				// change to the directory
		RecurseDelete();					// call this function
		_tchdir(_T("..");					// avoid cutting yourself off
		RemoveDirectory(szDirDoDelete);		// call win32 fn to remove directory
	
	****Current directory MUST BE SET before calling!****
	
	@retval Returns TRUE if admin, FALSE if not admin.
*/
void RecurseDelete()
{
	WIN32_FIND_DATA findData;				// information about found files
	static int		nLevel;					// depth level of directory, 
											// initialized to 0, shared between 
											// recursed versions
	HANDLE			hFile;					// handle for first file
	BOOL			bRet=TRUE;				// return value from find next
	TCHAR			szCurDir[_MAX_PATH];	// current directory

	// grab our directory
	_tgetcwd(szCurDir, _MAX_PATH);		
	
	// add *.*
	_tcscat(szCurDir, FINDWHAT);

	// grab the first file
	hFile = FindFirstFile(szCurDir, &findData);

	while (hFile != INVALID_HANDLE_VALUE && bRet)
	{	
		// we must ignore the special cases of "." and ".." that
		// show up as directories.  We do not want to chdir to those...
		if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY &&
			findData.cFileName[0] != _T('.'))
		{
			// we're a directory, so change to it
			if (0 == _tchdir((TCHAR*)findData.cFileName))
			{
				// increment the level
				++nLevel;
				// and find all the files (recursion)
				RecurseDelete();

				// and remove the directory where we just deleted the files
				RemoveDirectory(findData.cFileName);

				// then grab the next file
				bRet = FindNextFile(hFile, &findData);
			}	// successfully changed directory
		}	
		else	// not a directory
		{	
			if (findData.cFileName[0] && findData.cFileName[0] != _T('.'))				
			{
				// zap the file
				DeleteFile(findData.cFileName);
			}
			
			// otherwise get the next file in the list
			bRet = FindNextFile(hFile, &findData);
			continue;
		}	// if not directory
	}	// end while
	
	
	// if we are at a lower level && done, go back up a level
	if (nLevel)
	{
		if (0 == _tchdir(_T("..")))
		{
			--nLevel;
			// cleanup handle
			FindClose(hFile);
			// this is where the recursion terminates
			return;
		}
	}

	// cleanup handle
	FindClose(hFile);
}




/*
	@func IsAdmin
	This function checks for admin priviliges for currently logged in user.  Stolen
	from MSDN.
	
	@retval Returns TRUE if admin, FALSE if not admin.
*/
BOOL IsAdmin(void)
{
	HANDLE						hAccessToken;			// access token
	UCHAR						InfoBuffer[1024];		// information buffer
	PTOKEN_GROUPS				ptgGroups;				// token info pointer
	DWORD						dwInfoBufferSize;		// size of buffer
	PSID						psidAdministrators;		// pointer to admin sid
	SID_IDENTIFIER_AUTHORITY	siaNtAuthority = SECURITY_NT_AUTHORITY;;			// the authaurity
	UINT						x;						// loop counter
	BOOL						bSuccess;				// success


	// initialize stuff
	ptgGroups= (PTOKEN_GROUPS)InfoBuffer;
	bSuccess = FALSE;	

	// get the token
	if(!OpenThreadToken(GetCurrentThread(), TOKEN_QUERY, TRUE, &hAccessToken ))
	{      
		if(GetLastError() != ERROR_NO_TOKEN)
			return FALSE;        

		// retry against process token if no thread token exists   
		if(!OpenProcessToken(GetCurrentProcess(), TOKEN_QUERY,	&hAccessToken))  
			return FALSE;      
	}
	
	bSuccess = GetTokenInformation(hAccessToken,TokenGroups,InfoBuffer,	1024, &dwInfoBufferSize); 
	CloseHandle(hAccessToken);

	if(!bSuccess)
	{
		return FALSE;
	}

	if(!AllocateAndInitializeSid(&siaNtAuthority, 2,SECURITY_BUILTIN_DOMAIN_RID, 
				DOMAIN_ALIAS_RID_ADMINS,	
				0, 0, 0, 0, 0, 0,  
				&psidAdministrators))        
	{
		return FALSE;
	}

	// assume that we don't find the admin SID.      
	bSuccess = FALSE;

	for(x=0;x<ptgGroups->GroupCount; x++)
	{
		if( EqualSid(psidAdministrators, ptgGroups->Groups[x].Sid) )
		{
			bSuccess = TRUE;
			break;
		}
	}

	FreeSid(psidAdministrators);      

	return bSuccess;
}
