#ifndef SERVDEF2_H
#define SERVDEF2_H

//
// Service Functions
//
prototype LONG Service.InstallChangeServiceConfig(HWND, LONG, LONG, LONG, LPSTR, LPSTR, POINTER, LPSTR, LPSTR, LPSTR, LPSTR);
prototype LONG Service.InstallCloseServiceHandle(HWND);
prototype LONG Service.InstallControlService(HWND, LONG, POINTER);
prototype LONG Service.InstallCreateService(HWND, LPSTR, LPSTR, LONG, LONG, LONG, LONG, LPSTR, LPSTR, POINTER, LPSTR, LPSTR, LPSTR, POINTER);
prototype LONG Service.InstallDeleteService(HWND);
prototype LONG Service.InstallEnumDependentServices(HWND, LONG, POINTER, LONG, POINTER, POINTER);
prototype LONG Service.InstallEnumServicesStatus(HWND, LONG, LONG, POINTER, LONG, POINTER, POINTER, POINTER);
prototype LONG Service.InstallGetServiceDisplayName(HWND, LPSTR, LPSTR, POINTER);
prototype LONG Service.InstallGetServiceKeyName(HWND, LPSTR, LPSTR, POINTER);
prototype LONG Service.InstallLockServiceDatabase(HWND, POINTER);
prototype LONG Service.InstallOpenSCManager(LPSTR, LPSTR, LONG, POINTER);
prototype LONG Service.InstallOpenService(HWND, LPSTR, LONG, POINTER);
prototype LONG Service.InstallQueryServiceConfig(HWND, POINTER, LONG, POINTER);
prototype LONG Service.InstallQueryServiceLockStatus(HWND, POINTER, LONG, POINTER);
prototype LONG Service.InstallQueryServiceObjectSecurity(HWND, LONG, POINTER, LONG, POINTER);
prototype LONG Service.InstallQueryServiceStatus(HWND, POINTER);
prototype LONG Service.InstallSetServiceObjectSecurity(HWND, LONG, POINTER);
prototype LONG Service.InstallStartService(HWND, LONG, POINTER);
prototype LONG Service.InstallUnlockServiceDatabase(HWND);


//
// Service Types (Bit Mask)
//
#define SERVICE_KERNEL_DRIVER          0x00000001
#define SERVICE_FILE_SYSTEM_DRIVER     0x00000002
#define SERVICE_ADAPTER                0x00000004
#define SERVICE_RECOGNIZER_DRIVER      0x00000008

#define SERVICE_DRIVER                 (SERVICE_KERNEL_DRIVER | SERVICE_FILE_SYSTEM_DRIVER | SERVICE_RECOGNIZER_DRIVER)

#define SERVICE_WIN32_OWN_PROCESS      0x00000010
#define SERVICE_WIN32_SHARE_PROCESS    0x00000020
#define SERVICE_WIN32                  (SERVICE_WIN32_OWN_PROCESS | SERVICE_WIN32_SHARE_PROCESS)

#define SERVICE_INTERACTIVE_PROCESS    0x00000100

#define SERVICE_TYPE_ALL               (SERVICE_WIN32  | SERVICE_ADAPTER | SERVICE_DRIVER  | SERVICE_INTERACTIVE_PROCESS)

//
// Start Type
//

#define SERVICE_BOOT_START             0x00000000
#define SERVICE_SYSTEM_START           0x00000001
#define SERVICE_AUTO_START             0x00000002
#define SERVICE_DEMAND_START           0x00000003
#define SERVICE_DISABLED               0x00000004

//
// Error control type
//
#define SERVICE_ERROR_IGNORE           0x00000000
#define SERVICE_ERROR_NORMAL           0x00000001
#define SERVICE_ERROR_SEVERE           0x00000002
#define SERVICE_ERROR_CRITICAL         0x00000003

//
// Controls
//
#define SERVICE_CONTROL_STOP           0x00000001
#define SERVICE_CONTROL_PAUSE          0x00000002
#define SERVICE_CONTROL_CONTINUE       0x00000003
#define SERVICE_CONTROL_INTERROGATE    0x00000004
#define SERVICE_CONTROL_SHUTDOWN       0x00000005

//
//  The following are masks for the predefined standard access types
//

#define DELETE                           (0x00010000L)
#define READ_CONTROL                     (0x00020000L)
#define WRITE_DAC                        (0x00040000L)
#define WRITE_OWNER                      (0x00080000L)
#define SYNCHRONIZE                      (0x00100000L)

#define STANDARD_RIGHTS_REQUIRED         (0x000F0000L)

#define STANDARD_RIGHTS_READ             (READ_CONTROL)
#define STANDARD_RIGHTS_WRITE            (READ_CONTROL)
#define STANDARD_RIGHTS_EXECUTE          (READ_CONTROL)

#define STANDARD_RIGHTS_ALL              (0x001F0000L)

#define SPECIFIC_RIGHTS_ALL              (0x0000FFFFL)

//
// Service Control Manager object specific access types
//
#define SC_MANAGER_CONNECT             0x0001
#define SC_MANAGER_CREATE_SERVICE      0x0002
#define SC_MANAGER_ENUMERATE_SERVICE   0x0004
#define SC_MANAGER_LOCK                0x0008
#define SC_MANAGER_QUERY_LOCK_STATUS   0x0010
#define SC_MANAGER_MODIFY_BOOT_CONFIG  0x0020

#define SC_MANAGER_ALL_ACCESS          (STANDARD_RIGHTS_REQUIRED | SC_MANAGER_CONNECT | SC_MANAGER_CREATE_SERVICE | SC_MANAGER_ENUMERATE_SERVICE | SC_MANAGER_LOCK | SC_MANAGER_QUERY_LOCK_STATUS | SC_MANAGER_MODIFY_BOOT_CONFIG)


//
// Service object specific access type
//
#define SERVICE_QUERY_CONFIG           0x0001
#define SERVICE_CHANGE_CONFIG          0x0002
#define SERVICE_QUERY_STATUS           0x0004
#define SERVICE_ENUMERATE_DEPENDENTS   0x0008
#define SERVICE_START                  0x0010
#define SERVICE_STOP                   0x0020
#define SERVICE_PAUSE_CONTINUE         0x0040
#define SERVICE_INTERROGATE            0x0080
#define SERVICE_USER_DEFINED_CONTROL   0x0100

#define SERVICE_ALL_ACCESS             (STANDARD_RIGHTS_REQUIRED | SERVICE_QUERY_CONFIG | SERVICE_CHANGE_CONFIG | SERVICE_QUERY_STATUS | SERVICE_ENUMERATE_DEPENDENTS | SERVICE_START | SERVICE_STOP | SERVICE_PAUSE_CONTINUE | SERVICE_INTERROGATE | SERVICE_USER_DEFINED_CONTROL)

//
// Security information
//

#define OWNER_SECURITY_INFORMATION       (0X00000001L)
#define GROUP_SECURITY_INFORMATION       (0X00000002L)
#define DACL_SECURITY_INFORMATION        (0X00000004L)
#define SACL_SECURITY_INFORMATION        (0X00000008L)

//
// Structures
//
typedef SERVICE_STATUS
begin
    NUMBER	dwServiceType;
    NUMBER	dwCurrentState;
    NUMBER	dwControlsAccepted;
    NUMBER	dwWin32ExitCode;
    NUMBER	dwServiceSpecificExitCode;
    NUMBER	dwCheckPoint;
    NUMBER	dwWaitHint;
end;

typedef ENUM_SERVICE_STATUS
begin
    POINTER	lpServiceName;
    POINTER	lpDisplayName;
    SERVICE_STATUS ServiceStatus;
end;

typedef QUERY_SERVICE_CONFIG
begin
	NUMBER	dwServiceType;
    NUMBER	dwStartType;
    NUMBER	dwErrorControl;
    POINTER	lpBinaryPathName;
    POINTER	lpLoadOrderGroup;
    NUMBER	dwTagId;
    POINTER	lpDependencies;
    POINTER	lpServiceStartName;
    POINTER	lpDisplayName;
end;

typedef QUERY_SERVICE_LOCK_STATUS
begin
    NUMBER	fIsLocked;
    POINTER	lpLockOwner;
    NUMBER	dwLockDuration;
end;

#endif



