package com.ofer.product;

import com.installshield.product.*;
import com.installshield.util.*;
import com.installshield.util.Log;
import com.installshield.wizard.service.*;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.exitcode.*;
import java.io.*;

/**
 *
 * <p>Title: Check administartor authentication on Mac OS-X </p>
 * <p>Description: Gets path of the AppleScript file at install time and
 * a different path to the AppleScript at uninstall time.
 * << Those input paths must not contain spaces! >>
 * OsxAdminPassword  Activates an AppleScript, in a Shell,
 * that triggers the first sudo command with prompt for authentication.
 * If the right password was entered the installation gets 5 minutes of
 * enabling sudo commands hassle-free (without asking for authentication again).
 * This action enables three fail tries before canceling the installation.
 * In case of three mistakes or the cancel button pressed,
 * this action cancels the installation.
 * A hidden parameter - authentication holds the result:
 * Success: authentication = 0.
 * Fail (wrong or error): authentication = 1.
 * Canceled by the user: authentication = -1.
 * This value can be checked for appropriate Finish dialog.
 * In case of fail OsxAdminPassword sends message to the installation log.
 * OsxAdminPassword checks the input-stream for a return value by the
 * AppleScript file, and according to this return-value decides if to cancel
 * the installation and what value to set the authentication property to.
 * Usually the SellScript is installed to $D(temp) in installation before
 * the OsxAdminPassword  in the sequence. This file needs to be installed to a
 * permanent folder if the installation continues, so it can be used during uninstall.
 * At the end of the uninstall it has to be deleted explicitly.</p>
 * @author Ofer Rivlin
 * @version 1.0
 */
public class OsxAdminPassword extends ProductAction{

  public int authentication = 0;

  private String installInFile;
  private String uninstallInFile;

  public void install(ProductActionSupport support) throws ProductException{
    this.generateSudo(support, installInFile);
  }

  public void uninstall(ProductActionSupport support) throws ProductException{
     this.generateSudo(support, uninstallInFile);
  }

  public void generateSudo(ProductActionSupport support, String inFilePath){

    int iCounter = 0;

   try {
     // Get an instance of FileService
     FileService fileserv = (FileService) getService(FileService.NAME);
     // Resolve the shell-script path
     String sShFilePath = resolveString(inFilePath);
     // File exists validation
     if (fileserv.fileExists(sShFilePath)) {
       /** Loop to get the authentication.
        * Exit the loop when a right authentication entered or
        * when the user pressed the cancel button or
        * after 3 failed tries
        */
       do{
         if (exShell(sShFilePath, support) == 0) {
           // Right authentication, exit the loop
           break;
         }
       }while( (++iCounter < 3) && (authentication != -1) );
       if (authentication != 0) {
           //Cancel the installation
           support.getOperationState().cancel();
       }
     }
     else {
       throw new IOException("file " + inFilePath + " could not found!");
     }
   }catch (ServiceException se) {
     logEvent(this, Log.ERROR, se.getMessage());
     authentication = 1;
     //Cancel the installation
     support.getOperationState().cancel();
   }catch(IOException e){
     logEvent(this, Log.ERROR, e.getMessage());
     authentication = 1;
     //Cancel the installation
     support.getOperationState().cancel();
   }
  }
  //Execute the Installer application
  private int exShell(String sShFilePath, ProductActionSupport support)
            throws IllegalArgumentException, IOException{

      authentication = 0;
      String sCmdl = "sh "; //Command-Line
      String sOut = null;

       try
       {
         sCmdl += sShFilePath;
         // Run a Unix shell command
         Process p = Runtime.getRuntime().exec(sCmdl);
         BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.
             getInputStream()));
         //Read the Error output
         while ( (sOut = stdInput.readLine()) != null) {
           if(sOut.compareToIgnoreCase("error") == 0){
             if( (sOut = stdInput.readLine()) != null) {
               if(sOut.compareToIgnoreCase("-927") == 0){
                 // The user pressed the Cancel button
                 logEvent(this, Log.ERROR, "Cnceled by the user in sudo authentication");
                 authentication = -1;
               }else{
                 // Wrong authentication or Error
                 logEvent(this, Log.ERROR, "Wrong sudo authentication");
                 authentication = 1;
               }
             }else{
               // Error
               logEvent(this, Log.ERROR, "Error in sudo");
               authentication = 1;
             }
             // Will cancel the installation
             return 1;
           }
         }
       }catch (IOException e){
         authentication = 1;
         logEvent(this, Log.ERROR, e.getMessage());
       }
       return 0;
  }

  public int getAuthentication(){
    return this.authentication;
  }

  public void setAuthentication(int authentication){
    this.authentication = authentication;
  }

  public String getInstallInFile(){
     return this.installInFile;
   }

   public void setInstallInFile(String installInFile){
     this.installInFile = installInFile;
   }

  public String getUninstallInFile(){
    return this.uninstallInFile;
  }

  public void setUninstallInFile(String UninstallInFile){
    this.uninstallInFile = UninstallInFile;
  }

  public void build(ProductBuilderSupport support){
    support.putRequiredService(FileService.NAME);
    support.putRequiredService(ExitCodeService.NAME);
  }
}
