'============================================================================
' RegisterTypeLib
'
' Script for use by Windows Installer as a custom action. Retrieves a
' typelib file from the installer property VAR_TYPELIB_FILE and registers
' it on the system using the Type Library Information object. Result is
' returned to the installer via the VAR_CUSTOM_ACTION_RESULT property.
'
' Returns: 0 for success, -1 otherwise
'
' Corey Frost
' 03-18-02
'============================================================================
Function RegisterTypeLib()

    nResult = -1

    'Get the file to register first
    strFile = Session.Property("VAR_TYPELIB_FILE")
    If strFile = "" Then
        Property("VAR_CUSTOM_ACTION_RESULT") = CStr(nResult)
        RegisterTypeLib = nResult
        Exit Function
    End If

    Set objApp = CreateObject("TLI.TLIApplication")

    If IsObject(objApp) Then

        Set objTLI = objApp.TypeLibInfoFromFile(strFile)

        if IsObject(objTLI) Then

            ' Register the type library
            objTLI.Register(strFile)

            ' We are finished with the the TypeLibInfo object
            Set objTLI = Nothing

            '0 is success
            nResult = 0

        End If

        Set objApp = Nothing

    End If

    Property("VAR_CUSTOM_ACTION_RESULT") = CStr(nResult)

    'Always return success to the installer, error code is set as property
    RegisterTypeLib = 1

End Function


'============================================================================
' UnRegisterTypeLib
'
' Script for use by Windows Installer as a custom action. Retrieves a
' typelib file from the installer property VAR_TYPELIB_FILE and unregisters
' it on the system using the Type Library Information object. Result is
' returned to the installer via the VAR_CUSTOM_ACTION_RESULT property.
'
' Returns: 0 for success, -1 otherwise
'
' Corey Frost
' 03-18-02
'============================================================================
Function UnRegisterTypeLib()

    nResult = -1

    'Get the file to register first
    strFile = Session.Property("VAR_TYPELIB_FILE")
    If strFile = "" Then
        Property("VAR_CUSTOM_ACTION_RESULT") = CStr(nResult)
        UnRegisterTypeLib = nResult
        Exit Function
    End If

    Set objApp = CreateObject("TLI.TLIApplication")

    If IsObject(objApp) Then

        Set objTLI = objApp.TypeLibInfoFromFile(strFile)

        if IsObject(objTLI) Then

            ' UnRegister the type library
            objTLI.UnRegister(strFile)

            ' We are finished with the the TypeLibInfo object
            Set objTLI = Nothing

            '0 is success
            nResult = 0

        End If

        Set objApp = Nothing

    End If

    Property("VAR_CUSTOM_ACTION_RESULT") = CStr(nResult)

    'Always return success to the installer, error code is set as property
    UnRegisterTypeLib = 1

End Function
