package license;

import java.io.FileInputStream;
import java.io.IOException;
import java.awt.*;
import java.awt.event.ComponentListener;
import java.awt.event.ComponentEvent;

import com.installshield.isjava.runtime.*;

public class CustomLicensePanel extends InfoPanel
                                implements ComponentListener
{
    private boolean bInitialized = false;
    private Checkbox chkAccept = new Checkbox("Accept all terms of the license");
	private ScrollPane sp = new ScrollPane();
	private TextDisplay text = new TextDisplay("Loading license file...", getFont());

	public CustomLicensePanel()
	{
	   	setLayout(new BorderLayout(0, 10));

    	TextDisplay message = new TextDisplay("Please read the following license agreement "
	                                        + "carefully.  To proceed, you must agree to "
	                                        + "all the terms of this license by checking "
	                                        + "the checkbox.", getFont());
		add(message, "North");
        sp.add(text);
		add(sp, "Center");
		add(chkAccept, "South");

        sp.addComponentListener(this);
	}


    public void enter(InstallContext ctx)
    {
        StringBuffer buf = new StringBuffer();
	
        if (!bInitialized)
        {
            try
            {
		        int ch;

		        // open license file in current directory and load string buffer
		        FileInputStream in = new FileInputStream("license.txt");
    		    while ((ch = in.read()) != -1)
    		    {
    		        switch (ch)
    		        {
    		            case '\t':
    		                // replace tabs with 5 spaces
    		                buf.append("     ");
    		                break;
    		            case '\n':
    		                // add a space after the newline char
    		                buf.append("\n ");
    		                break;
    		            default:
	    	                buf.append((char)ch);
	    	                break;
	    	        }
	    	           
	    	    }

                in.close();
            }
            catch (IOException e)
            {
                text.setText("Unable to load license file.");
                return;
            }

         	// set the scrollbar increments
         	FontMetrics fm = getFontMetrics(getFont());
    		sp.getHAdjustable().setUnitIncrement(fm.getMaxAdvance());
            sp.getVAdjustable().setUnitIncrement(fm.getHeight());

            text.setText(buf.toString(), fm.charWidth(' '));
            sp.doLayout();
            
            bInitialized = true;
        }
    }


    public void componentResized(ComponentEvent e)
    {
        // resize TextDisplay if ScrollPane is resized
        text.setSize(sp.getSize().width - 20, text.getSize().height);
    }

	
	public String getTitle()
	{
	    return "Software License Agreement";
    }
	
	
	public boolean verify(InstallContext ctx)
	{
       	if (chkAccept.getState() == false)
       	{
       		String errorMsg = "To proceed, you must first accept the terms of the license "
       		                + "by checking the checkbox.";
           	ctx.showErrorMessage("License", errorMsg);
            return false;
		}
		
		return true;
	}


    public void componentShown(ComponentEvent e)
    {}

	
    public void componentMoved(ComponentEvent e)
    {}

	
    public void componentHidden(ComponentEvent e)
    {}

	
}
