////////////////////////////////////////////////////////
// Commandline Parsing
// v1.0, 25 Feb 1999
//
// Troy Engel <tengel@abtcorp.com>
////////////////////////////////////////////////////////
#ifndef _CMDLINEP_H_
#define _CMDLINEP_H_

prototype	ParseCommandLine();
// ParseCmdLine()
// This function will take the CMDLINE var and seperate it at
// double dashes ("--"), placing the results of each "--" arguement
// into the list 'cmdLineList'.  An example:
//
// setup.exe --default-option1=Foo --defa-opt2=Bar Mitzvah --whatever=bar
//
// Would result in a three item list:
//
// default-option1=Foo
// defa-opt2=Bar Mitzvah
// whatever=bar
//
// NOTE: no need to use quotes around params with spaces - the routine looks
// specifically for -- marks to seperate

prototype	GetCommandLineOption(STRING, BYREF STRING);
// GetCommandLineOption()
// This helper function will place the value of the first parameter into the
// second.  It looks for the equal sign ("=") and uses whatever is to the right
// of that.  Which means, you must use an equal sign in the commandline! :)
// An example, using the above data:
//
// STRING szResult;
// GetCommandLineOption("defa-opt2", szResult);
// MessageBox(szResult, INFORMATION);

LIST		cmdLineList; // cmdline parameters are stored here

#endif // _CMDLINEP_H_

