/*
	$Workfile: $
	$Header:   $

	Copyright  1997-2003 MDS SCIEX.
	All rights reserved.

	by Friedrich Brunzema mailto:brunzefb@yahoo.com

	@doc
	@module REBOOTME.cpp - reboot NT/2000/XP computer |

	Revision History:
		F.B. - 2003 Nov 2  Initial Revision
		
	$Log:  $ 
*/


// includes
#include "stdafx.h"
#include <windows.h>
#include "getopt.h"

// function prototypes
BOOL		MySystemShutdown();
BOOL WINAPI HandlerRoutine( DWORD dwCtrlType);
void		repeat_put_to_stream(FILE* stream, TCHAR c, int count);
void		process_arguments(int argc, TCHAR *argv[]);
void		show_info();
void		WaitForFileToExist();

// globals
TCHAR g_szPathToFile[255];			// global, path to file to monitor
bool  g_fMonitor;					// do we monitor?


// main entry point into the program
int _tmain(int argc, _TCHAR* argv[])
{
	BOOL	bRet = FALSE;
	int		i;
	
	process_arguments(argc, argv);

	if (g_fMonitor)
	{
		WaitForFileToExist();
	}

	_ftprintf(stdout, _T("\nAttempting SYSTEM SHUTDOWN in 10 seconds!\n"));
	_ftprintf(stdout, _T("Use Ctrl+C to abort\n"));

	// we capture CTRL+C, so that users can abort the shutdown
	SetConsoleCtrlHandler(HandlerRoutine, TRUE);

	// give the user feedback on how much time is left before system goes down
	_ftprintf(stdout, _T("\nSystem Shutdown happens in 10 seconds"));
	for (i=9; i>=0; --i)
	{
		// erase the lasts characters first, then put the new time back
		repeat_put_to_stream(stdout, _T('\b'), 10);
		_ftprintf(stdout, _T("%02d seconds"), i);
		Sleep(1000);
	}

	// call the shutdown routine
	bRet = MySystemShutdown();
	if (!bRet)
	{
		_ftprintf(stdout, _T("\nCould not shutdown!\n"));
	}
	else
	{
		_ftprintf(stdout, _T("\nShutting Down System.  Bye Bye!\n"));
	}

	return 0;
}


// this function writes a single character count times into a stream
void repeat_put_to_stream(FILE* stream, TCHAR c, int count)
{
	int i;
	for (i=0; i<count; i++)
	{
		_fputtc(c, stream);
	}
}



// taken mostly from MSDN, this function acquires process shutdown priviliges (if NT/XP/2K)
// and takes the system down
BOOL MySystemShutdown()
{
	HANDLE hToken; 
	TOKEN_PRIVILEGES tkp; 

	if( GetVersion() < 0x80000000 ) // top bit cleared if NT, XP or Win2K
	{
		// do this only for NT, XP and Win2K
		// get our process token
		if (!OpenProcessToken(GetCurrentProcess(), 
				TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken)) 
		{
			return( FALSE ); 
		}

		// find priv value
		LookupPrivilegeValue(NULL, SE_SHUTDOWN_NAME, &tkp.Privileges[0].Luid); 

		tkp.PrivilegeCount = 1;  // one privilege to set    
		tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED; 

		// give our process the shutdown right
		AdjustTokenPrivileges(hToken, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES)NULL, 0); 

		// did we do it?
		if (GetLastError() != ERROR_SUCCESS) 
		{
			return FALSE; 
		}
	}

	// Change these flags to change behavior - right now
	// this will shut down without sending WM_QUERYENDSESSION
	// look on http://msdn.microsoft.com/library for more info
	if (!ExitWindowsEx(EWX_REBOOT | EWX_FORCE, 0)) 
	{
		return FALSE; 
	}

	// otherwise peachy...
	return TRUE;
}


// this routine gets called by the OS when CTRL+C is pressed
BOOL WINAPI HandlerRoutine( DWORD dwCtrlType)
{
	switch(dwCtrlType)
	{
		case CTRL_C_EVENT:
		case CTRL_BREAK_EVENT:
			exit(1);
		default:
			;
	}
	return FALSE;
}


// this is to process command line arguments
void process_arguments(int argc, TCHAR *argv[])
{
    TCHAR       c;                          /* flag specifed, used w/getopt  */
	int			optind;						// option index
	TCHAR*		pOptArg;					// optional arg
	
	// init
	optind = 0;

    /*
     * GETOPT is an easy way to parse command line arguments
     * Each parameter which can have a flag is passed in the third argument
     * to getopt.  Getopt returns the character of the flag on the command
     * line and sets optarg to point to the value associated with the flag.
     * optind is the index of the argument that getopt is currently processing.
     */
    while (optind != argc) 
	{
		c = GetOption(argc, argv, _T("?:w:"), &pOptArg);
        switch (c) 
		{
			case 0:			// reached the end of the list
				break;

			case 1:			// pOptArg has our non optional argument
				break;

			case _T('?'):	// user needs help
				show_info();
				exit(1);
				break;
        
			case _T('w'): // version
				_tcscpy(g_szPathToFile, pOptArg);
				g_fMonitor = true;
				break;

			
			default:
				_ftprintf(stdout, _T("Invalid flag.  Use Rebootme -? for usage\n"));
				exit(1);
        }
		++optind;
    }
}


// this function displays the help
void show_info()
{
	// show dump utility usage information
	_ftprintf(stdout,	
		_T("\nRebootMe -- Reboots a system\n\n")
		_T("usage: RebootMe [-w Path] \n")
		_T("       RebootMe [-?] \n\n")
		_T("  Starts a system shutdown in 10 seconds\n\n")
		_T("   /w [UNC path]   The file [path] must exist before attempting a shutdown\n")
		_T("   /?              Displays this help message.\n")
			);
}


// this function causes us to wait for the specified file
void WaitForFileToExist()
{
	const TCHAR display[] = _T("*|/-\\$");
	HANDLE hFile = INVALID_HANDLE_VALUE;
	int ct = 0;

	_ftprintf(stdout, "System will shut down when following file becomes available:\n%s  (Press CTRL+C to abort)\n", g_szPathToFile);
	_fputtc(_T('$'), stdout);
	
	do
	{
		// try to open for read, this will work with a UNC path
		// whereas PathFileExists() does not work with UNC paths
		hFile = CreateFile( g_szPathToFile,
							GENERIC_READ,
							FILE_SHARE_READ,
							NULL,
							OPEN_EXISTING,
							FILE_ATTRIBUTE_NORMAL,
							NULL);

		// don't wait more if the  file becomes available
		if (hFile!=INVALID_HANDLE_VALUE)
		{
			CloseHandle(hFile);
			break;
		}

		// display that we are still alive
		++ct;
		_fputtc(_T('\b'), stdout);
		_fputtc(display[ct%5], stdout);
		Sleep(5000);

	} while (hFile == INVALID_HANDLE_VALUE);

	// OK, file is now available...
	_fputts(_T("\bFile Now Available!\n"), stdout);

}